"use strict";
const common_vendor = require("../../common/vendor.js");
if (!Array) {
  const _component_uni_icons = common_vendor.resolveComponent("uni-icons");
  _component_uni_icons();
}
if (!Math) {
  FamilyTreeNode();
}
const FamilyTreeNode = () => "../../components/FamilyTreeNode.js";
const padding = 100;
const _sfc_main = {
  __name: "test",
  setup(__props) {
    const windowWidth = common_vendor.ref(0);
    const windowHeight = common_vendor.ref(0);
    const canvasWidth = common_vendor.ref(0);
    const canvasHeight = common_vendor.ref(0);
    const offsetX = common_vendor.ref(0);
    const offsetY = common_vendor.ref(0);
    const scale = common_vendor.ref(1);
    const isDragging = common_vendor.ref(false);
    const lastTouch = common_vendor.ref(null);
    const loading = common_vendor.ref(false);
    const rootNode = common_vendor.ref(null);
    const containerStyle = common_vendor.computed(() => ({
      transform: `translate(${offsetX.value}px, ${offsetY.value}px) scale(${scale.value})`,
      width: canvasWidth.value + "px",
      height: canvasHeight.value + "px",
      transformOrigin: "top left"
    }));
    common_vendor.onMounted(() => {
      const systemInfo = common_vendor.index.getSystemInfoSync();
      windowWidth.value = systemInfo.windowWidth;
      windowHeight.value = systemInfo.windowHeight;
      canvasWidth.value = windowWidth.value * 3;
      canvasHeight.value = windowHeight.value * 3;
      offsetX.value = -(canvasWidth.value / 2) + windowWidth.value / 2;
      offsetY.value = -(canvasHeight.value / 2) + windowHeight.value / 2;
      initRootNode();
    });
    const initRootNode = () => {
      const userInfo = common_vendor.index.getStorageSync("userInfo") || {
        uid: "user_001",
        username: "张三",
        xing: "张",
        ming: "三",
        gender_index: 0,
        birthday: "1990-01-01",
        avatarUrl: "/static/avatar.png"
      };
      rootNode.value = {
        uid: userInfo.uid,
        name: userInfo.xing + userInfo.ming,
        avatar: userInfo.avatarUrl,
        birthYear: userInfo.birthday.split("-")[0] || "未知",
        gender: userInfo.gender_index,
        expanded: true,
        // 默认展开根节点
        hasLoaded: false,
        parents: [],
        family: [],
        position: {
          x: canvasWidth.value / 2 - 90,
          y: canvasHeight.value / 2 - 40
        }
      };
      common_vendor.index.__f__("log", "at pages/test/test.vue:111", "根节点初始化:", rootNode.value);
    };
    const updateNode = (node, newData) => {
      const newNode = { ...node, ...newData };
      const newTree = JSON.parse(JSON.stringify(rootNode.value));
      findAndUpdateNode(newTree, node.uid, newNode);
      rootNode.value = newTree;
    };
    const findAndUpdateNode = (currentNode, uid, newData) => {
      if (currentNode.uid === uid) {
        Object.assign(currentNode, newData);
        return true;
      }
      if (currentNode.parents) {
        for (const parent of currentNode.parents) {
          if (findAndUpdateNode(parent, uid, newData))
            return true;
        }
      }
      if (currentNode.family) {
        for (const member of currentNode.family) {
          if (findAndUpdateNode(member, uid, newData))
            return true;
        }
      }
      return false;
    };
    const handleNodeClick = async (node) => {
      common_vendor.index.__f__("log", "at pages/test/test.vue:148", "节点点击:", node.name);
      if (node.hasLoaded) {
        common_vendor.index.__f__("log", "at pages/test/test.vue:151", "切换展开状态:", !node.expanded);
        updateNode(node, { expanded: !node.expanded });
        return;
      }
      common_vendor.index.__f__("log", "at pages/test/test.vue:156", "加载节点数据...");
      loading.value = true;
      try {
        await new Promise((resolve) => setTimeout(resolve, 800));
        const parents = [
          createMockNode(node, "parent", 0, node.gender === 0 ? "父亲" : "母亲", 0, "1950"),
          createMockNode(node, "parent", 1, node.gender === 0 ? "母亲" : "父亲", 1, "1952")
        ];
        const family = [
          createMockNode(node, "family", 0, node.gender === 0 ? "妻子" : "丈夫", node.gender === 0 ? 1 : 0, "1982"),
          createMockNode(node, "family", 1, "孩子", Math.round(Math.random()), "2010")
        ];
        updateNode(node, {
          expanded: true,
          hasLoaded: true,
          parents,
          family
        });
        common_vendor.index.__f__("log", "at pages/test/test.vue:182", "节点更新完成:", node.name, parents, family);
      } catch (error) {
        common_vendor.index.__f__("error", "at pages/test/test.vue:184", "加载失败:", error);
        common_vendor.index.showToast({ title: "加载失败", icon: "none" });
      } finally {
        loading.value = false;
      }
    };
    const createMockNode = (parentNode, type, index, name, gender, birthYear) => {
      const baseX = parentNode.position.x;
      const baseY = parentNode.position.y;
      const spacing = 180 * scale.value;
      const verticalDistance = 150 * scale.value;
      let x, y;
      if (type === "parent") {
        x = baseX + (index === 0 ? -spacing : spacing);
        y = baseY - verticalDistance;
      } else {
        x = baseX + (index * spacing - spacing);
        y = baseY + verticalDistance;
      }
      x = Math.max(50, Math.min(canvasWidth.value - 230, x));
      y = Math.max(50, Math.min(canvasHeight.value - 130, y));
      return {
        uid: `${type}_${Date.now()}_${index}`,
        name,
        avatar: gender === 0 ? "/static/avatar-male.png" : "/static/avatar-female.png",
        birthYear,
        gender,
        expanded: false,
        hasLoaded: false,
        parents: [],
        family: [],
        position: { x, y }
      };
    };
    const checkBoundaries = (newOffsetX, newOffsetY) => {
      const screenWidth = windowWidth.value;
      const screenHeight = windowHeight.value;
      const scaledWidth = canvasWidth.value * scale.value;
      const scaledHeight = canvasHeight.value * scale.value;
      let constrainedX = newOffsetX;
      if (scaledWidth <= screenWidth - 2 * padding) {
        constrainedX = (screenWidth - scaledWidth) / 2;
      } else {
        constrainedX = Math.min(
          Math.max(newOffsetX, screenWidth - scaledWidth - padding),
          padding
        );
      }
      let constrainedY = newOffsetY;
      if (scaledHeight <= screenHeight - 2 * padding) {
        constrainedY = (screenHeight - scaledHeight) / 2;
      } else {
        constrainedY = Math.min(
          Math.max(newOffsetY, screenHeight - scaledHeight - padding),
          padding
        );
      }
      return {
        offsetX: constrainedX,
        offsetY: constrainedY
      };
    };
    const handleTouchStart = (e) => {
      if (e.touches.length === 1) {
        isDragging.value = true;
        lastTouch.value = {
          x: e.touches[0].pageX,
          y: e.touches[0].pageY
        };
      }
    };
    const handleTouchMove = (e) => {
      if (!isDragging.value || !lastTouch.value)
        return;
      const touch = e.touches[0];
      const deltaX = touch.pageX - lastTouch.value.x;
      const deltaY = touch.pageY - lastTouch.value.y;
      const newOffsetX = offsetX.value + deltaX;
      const newOffsetY = offsetY.value + deltaY;
      const constrained = checkBoundaries(newOffsetX, newOffsetY);
      offsetX.value = constrained.offsetX;
      offsetY.value = constrained.offsetY;
      lastTouch.value = {
        x: touch.pageX,
        y: touch.pageY
      };
    };
    const handleTouchEnd = () => {
      isDragging.value = false;
      lastTouch.value = null;
    };
    const handleMagnifierTap = (type) => {
      const step = 0.1;
      let newScale = scale.value;
      if (type === "big") {
        newScale = Math.min(scale.value + step, 2);
      } else {
        newScale = Math.max(scale.value - step, 0.5);
      }
      scale.value = newScale;
    };
    const handlerestoreCenter = () => {
      scale.value = 1;
      offsetX.value = -(canvasWidth.value / 2) + windowWidth.value / 2;
      offsetY.value = -(canvasHeight.value / 2) + windowHeight.value / 2;
    };
    return (_ctx, _cache) => {
      return common_vendor.e({
        a: common_vendor.p({
          type: "plus",
          size: "24",
          color: "#fff"
        }),
        b: common_vendor.o(($event) => handleMagnifierTap("big")),
        c: common_vendor.p({
          type: "home",
          size: "24",
          color: "#fff"
        }),
        d: common_vendor.o(handlerestoreCenter),
        e: common_vendor.p({
          type: "minus",
          size: "24",
          color: "#fff"
        }),
        f: common_vendor.o(($event) => handleMagnifierTap("small")),
        g: rootNode.value
      }, rootNode.value ? {
        h: common_vendor.o(handleNodeClick),
        i: common_vendor.p({
          node: rootNode.value
        })
      } : {}, {
        j: common_vendor.s(containerStyle.value),
        k: common_vendor.o(handleTouchStart),
        l: common_vendor.o(handleTouchMove),
        m: common_vendor.o(handleTouchEnd),
        n: loading.value
      }, loading.value ? {} : {});
    };
  }
};
wx.createPage(_sfc_main);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/test/test.js.map
