"use strict";
const common_vendor = require("../../../common/vendor.js");
const common_assets = require("../../../common/assets.js");
const utils_request = require("../../../utils/request.js");
const _sfc_main = {
  __name: "view_userinfo",
  setup(__props) {
    const gender_options = [
      {
        label: "男"
      },
      {
        label: "女"
      },
      {
        label: "保密"
      }
    ];
    const gender_labels = gender_options.map((item) => item.label);
    const user_info = common_vendor.ref({});
    common_vendor.onLoad((options) => {
    });
    common_vendor.onShow(async (options) => {
      showToastIfPresent(options);
      await update_user_info();
    });
    function showToastIfPresent(options) {
      if (options && options.showToastTitle) {
        common_vendor.index.showToast({
          title: options.showToastTitle,
          icon: options.showToastIcon || "none"
        });
      }
    }
    async function update_user_info() {
      const stored_info = common_vendor.index.getStorageSync("user_info");
      if (stored_info && stored_info.uid) {
        user_info.value = stored_info;
        return;
      }
    }
    const navigate_to_input = (field, title) => {
      common_vendor.index.navigateTo({
        url: `/pages/profile/editinput/editinput?field=${field}&title=${title}&inputValue=${user_info.value[field]}&xing=${user_info.value.xing}&ming=${user_info.value.ming}`
      });
    };
    let new_avatar_url = "";
    const choose_avatar = () => {
      const platform = common_vendor.index.getSystemInfoSync().uniPlatform;
      common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:130", platform);
      if (platform == "h5" || platform == "web") {
        common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:132", "111");
        common_vendor.index.chooseImage({
          count: 1,
          sizeType: ["compressed"],
          sourceType: ["album", "camera"],
          success: async (res) => {
            const temp_file_path = res.tempFilePaths[0];
            common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:139", "📸 选择的文件:", temp_file_path);
            try {
              const result = await utils_request.upload_file(temp_file_path, {
                path: "avatar",
                on_progress: (progress) => {
                  common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:144", `上传进度: ${progress}%`);
                }
              });
              common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:147", "✅ 上传成功:", result);
              new_avatar_url = result.data.image_url;
              user_info.value.avatar_url = new_avatar_url;
              const edit_dict = {
                edit_dict: {
                  avatar_url: new_avatar_url
                }
              };
              const response = await utils_request.http_request("edit_userinfo", edit_dict, true);
              save_user_info();
              common_vendor.index.showToast({
                title: "上传成功",
                icon: "success"
              });
            } catch (error) {
              common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:162", "上传失败:", error);
            }
          }
        });
      } else {
        common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:167", "222");
        common_vendor.index.chooseMedia({
          count: 1,
          mediaType: ["image"],
          sourceType: ["album", "camera"],
          success: async (res) => {
            common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:173", "📸 选择的文件:", res.tempFiles);
            const temp_file_path = res.tempFiles[0].tempFilePath;
            try {
              const result = await utils_request.upload_file(temp_file_path, {
                path: "avatar",
                on_progress: (progress) => {
                  common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:179", `上传进度: ${progress}%`);
                }
              });
              common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:182", "✅ 上传成功:", result);
              new_avatar_url = result.data.image_url;
              user_info.value.avatar_url = new_avatar_url;
              const edit_dict = {
                edit_dict: {
                  avatar_url: new_avatar_url
                }
              };
              const response = await utils_request.http_request("edit_userinfo", edit_dict, true);
              save_user_info();
              common_vendor.index.showToast({
                title: "上传成功",
                icon: "success"
              });
            } catch (error) {
              common_vendor.index.__f__("log", "at pages/profile/view_userinfo/view_userinfo.vue:198", "上传失败:", error);
            }
          }
        });
      }
    };
    const handle_change_gender = async (e) => {
      const index = Number(e.detail.value);
      user_info.value.gender_index = index;
      common_vendor.index.getStorageSync("token");
      const edit_dict = {
        edit_dict: {
          gender_index: index
        }
      };
      await utils_request.http_request("/edit_userinfo", edit_dict, true);
      save_user_info();
    };
    const handle_change_birthday = async (e) => {
      user_info.value.birthday = e.detail.value;
      const edit_dict = {
        edit_dict: {
          birthday: e.detail.value
        }
      };
      await utils_request.http_request("/edit_userinfo", edit_dict, true);
      save_user_info();
    };
    const save_user_info = () => {
      common_vendor.index.setStorageSync("user_info", user_info.value);
    };
    return (_ctx, _cache) => {
      return {
        a: user_info.value.avatar_url || "/static/image/profile.png",
        b: common_assets._imports_0$1,
        c: common_vendor.o(choose_avatar),
        d: common_vendor.t(user_info.value.username || "未设置"),
        e: common_assets._imports_0$1,
        f: common_vendor.o(($event) => navigate_to_input("username", "姓名")),
        g: common_vendor.t(common_vendor.unref(gender_labels)[user_info.value.gender_index] || "保密"),
        h: common_assets._imports_0$1,
        i: common_vendor.unref(gender_labels),
        j: user_info.value.gender_index,
        k: common_vendor.o(handle_change_gender),
        l: common_vendor.t(user_info.value.birthday || "未设置"),
        m: common_assets._imports_0$1,
        n: user_info.value.birthday,
        o: common_vendor.o(handle_change_birthday),
        p: common_vendor.t(user_info.value.phone_number || "未设置"),
        q: common_assets._imports_0$1,
        r: common_vendor.o(($event) => navigate_to_input("phone_number", "手机号"))
      };
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-afc4897a"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../../.sourcemap/mp-weixin/pages/profile/view_userinfo/view_userinfo.js.map
