"use strict";
const common_vendor = require("../../../common/vendor.js");
const utils_request = require("../../../utils/request.js");
const _sfc_main = {
  __name: "register",
  setup(__props) {
    const platform = common_vendor.ref("");
    const account = common_vendor.ref("");
    const password = common_vendor.ref("");
    const confirm_password = common_vendor.ref("");
    const account_valid = common_vendor.ref(false);
    const password_valid = common_vendor.ref(false);
    const confirm_password_valid = common_vendor.ref(false);
    const is_agreed = common_vendor.ref(false);
    const account_blurred = common_vendor.ref(false);
    const password_blurred = common_vendor.ref(false);
    const confirm_password_blurred = common_vendor.ref(false);
    const account_message = common_vendor.ref("");
    const password_message = common_vendor.ref("");
    const confirm_password_message = common_vendor.ref("");
    const registering = common_vendor.ref(false);
    common_vendor.onLoad((options) => {
      const system_info = common_vendor.index.getSystemInfoSync();
      platform.value = system_info.uniPlatform;
      if (options.showToastTitle) {
        common_vendor.index.showToast({
          title: options.showToastTitle,
          icon: options.showToastIcon || "none"
        });
      }
    });
    const validate_account = () => {
      var _a;
      account_blurred.value = true;
      const value = (_a = account.value) == null ? void 0 : _a.trim();
      if (!value) {
        account_message.value = "请输入账号";
        account_valid.value = false;
        return;
      }
      const phone_regex = /^1[0-9]{10}$/;
      const email_regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (phone_regex.test(value)) {
        account_message.value = "手机号格式正确";
        account_valid.value = true;
      } else if (email_regex.test(value)) {
        account_message.value = "邮箱格式正确";
        account_valid.value = true;
      } else {
        account_message.value = "仅支持邮箱或手机号";
        account_valid.value = false;
      }
    };
    const validate_password = () => {
      var _a;
      password_blurred.value = true;
      const value = (_a = password.value) == null ? void 0 : _a.trim();
      if (!value) {
        password_message.value = "请输入密码";
        password_valid.value = false;
        return;
      }
      if (value.length < 6) {
        password_message.value = "密码不能少于6位";
        password_valid.value = false;
      } else if (value.length > 20) {
        password_message.value = "密码不能超过20位";
        password_valid.value = false;
      } else {
        password_message.value = "密码格式正确";
        password_valid.value = true;
      }
      if (confirm_password_blurred.value) {
        validate_confirm_password();
      }
    };
    const validate_confirm_password = () => {
      var _a;
      confirm_password_blurred.value = true;
      const value = (_a = confirm_password.value) == null ? void 0 : _a.trim();
      if (!value) {
        confirm_password_message.value = "请确认密码";
        confirm_password_valid.value = false;
        return;
      }
      if (value !== password.value) {
        confirm_password_message.value = "两次密码不一致";
        confirm_password_valid.value = false;
      } else {
        confirm_password_message.value = "密码确认正确";
        confirm_password_valid.value = true;
      }
    };
    const can_register = common_vendor.computed(() => {
      return account_valid.value && password_valid.value && confirm_password_valid.value && is_agreed.value && !registering.value;
    });
    const account_input_class = common_vendor.computed(() => ({
      valid: account_valid.value,
      invalid: !account_valid.value && account_blurred.value
    }));
    const account_message_class = common_vendor.computed(() => ({
      message: true,
      valid: account_valid.value,
      invalid: !account_valid.value && account_blurred.value
    }));
    const password_input_class = common_vendor.computed(() => ({
      valid: password_valid.value,
      invalid: !password_valid.value && password_blurred.value
    }));
    const password_message_class = common_vendor.computed(() => ({
      message: true,
      valid: password_valid.value,
      invalid: !password_valid.value && password_blurred.value
    }));
    const confirm_password_input_class = common_vendor.computed(() => ({
      valid: confirm_password_valid.value,
      invalid: !confirm_password_valid.value && confirm_password_blurred.value
    }));
    const confirm_password_message_class = common_vendor.computed(() => ({
      message: true,
      valid: confirm_password_valid.value,
      invalid: !confirm_password_valid.value && confirm_password_blurred.value
    }));
    const toggle_agreement = () => {
      is_agreed.value = !is_agreed.value;
    };
    const navigate_to_agreement = (type) => {
      common_vendor.index.navigateTo({
        url: `/pages/profile/agreement/${type}`
      });
    };
    const on_register = async () => {
      if (!can_register.value)
        return;
      registering.value = true;
      try {
        const result = await utils_request.http_request("/register_user", {
          account: account.value,
          password: password.value
        }, false);
        if (result.code === 200) {
          common_vendor.index.showToast({
            title: "注册成功",
            icon: "success"
          });
          const {
            access_token,
            refresh_token,
            expires_in
          } = result.data;
          common_vendor.index.setStorageSync("access_token", access_token);
          common_vendor.index.setStorageSync("refresh_token", refresh_token);
          common_vendor.index.setStorageSync("token_expire", Date.now() + expires_in * 1e3);
          const result2 = await utils_request.http_request("/get_my_userinfo", {}, true);
          if (result2.code === 200) {
            common_vendor.index.setStorageSync("user_info", result2.userinfo);
            setTimeout(() => {
              common_vendor.index.reLaunch({
                url: "/pages/profile/profile?showToastTitle=请修改用户信息"
              });
            }, 500);
          } else {
            common_vendor.index.showToast({
              title: result2.msg || "获取用户信息失败",
              icon: "none"
            });
          }
        } else {
          common_vendor.index.showToast({
            title: result.msg || "注册失败",
            icon: "none"
          });
        }
      } catch (error) {
        common_vendor.index.__f__("error", "at pages/profile/register/register.vue:290", "注册异常：", error);
        common_vendor.index.showToast({
          title: "网络异常，请重试",
          icon: "none"
        });
      } finally {
        registering.value = false;
      }
    };
    const on_wx_register = async () => {
      common_vendor.index.login({
        provider: "weixin",
        success: async (res) => {
          const code = res.code;
          try {
            const result = await utils_request.http_request("/register_user", {
              code
            }, false);
            if (result.code === 200) {
              common_vendor.index.showToast({
                title: "微信注册成功",
                icon: "success"
              });
              const {
                access_token,
                refresh_token,
                expires_in
              } = result.data;
              common_vendor.index.setStorageSync("access_token", access_token);
              common_vendor.index.setStorageSync("refresh_token", refresh_token);
              common_vendor.index.setStorageSync("token_expire", Date.now() + expires_in * 1e3);
              const result2 = await utils_request.http_request("/get_my_userinfo", {}, true);
              if (result2.code === 200) {
                common_vendor.index.setStorageSync("user_info", result2.userinfo);
                setTimeout(() => {
                  common_vendor.index.reLaunch({
                    url: "/pages/profile/profile?showToastTitle=请修改用户信息"
                  });
                }, 500);
              } else {
                common_vendor.index.showToast({
                  title: result2.msg || "获取用户信息失败",
                  icon: "none"
                });
              }
            } else {
              common_vendor.index.showToast({
                title: result.msg || "注册失败",
                icon: "none"
              });
            }
          } catch (error) {
            common_vendor.index.__f__("error", "at pages/profile/register/register.vue:345", "微信注册请求出错：", error);
            common_vendor.index.showToast({
              title: "网络错误或服务器异常",
              icon: "none"
            });
          }
        },
        fail: () => {
          common_vendor.index.showToast({
            title: "微信登录失败",
            icon: "none"
          });
        }
      });
    };
    return (_ctx, _cache) => {
      return common_vendor.e({
        a: platform.value === "web"
      }, platform.value === "web" ? common_vendor.e({
        b: common_vendor.n(account_input_class.value),
        c: common_vendor.o(validate_account),
        d: account.value,
        e: common_vendor.o(($event) => account.value = $event.detail.value),
        f: account_message.value
      }, account_message.value ? {
        g: common_vendor.t(account_message.value),
        h: common_vendor.n(account_message_class.value)
      } : {}, {
        i: common_vendor.n(password_input_class.value),
        j: common_vendor.o(validate_password),
        k: password.value,
        l: common_vendor.o(($event) => password.value = $event.detail.value),
        m: password_message.value
      }, password_message.value ? {
        n: common_vendor.t(password_message.value),
        o: common_vendor.n(password_message_class.value)
      } : {}, {
        p: common_vendor.n(confirm_password_input_class.value),
        q: common_vendor.o(validate_confirm_password),
        r: confirm_password.value,
        s: common_vendor.o(($event) => confirm_password.value = $event.detail.value),
        t: confirm_password_message.value
      }, confirm_password_message.value ? {
        v: common_vendor.t(confirm_password_message.value),
        w: common_vendor.n(confirm_password_message_class.value)
      } : {}, {
        x: is_agreed.value,
        y: common_vendor.o(toggle_agreement),
        z: common_vendor.o(($event) => navigate_to_agreement("user")),
        A: common_vendor.o(($event) => navigate_to_agreement("privacy")),
        B: common_vendor.o(toggle_agreement),
        C: common_vendor.t(registering.value ? "注册中..." : "注 册"),
        D: !can_register.value ? 1 : "",
        E: !can_register.value,
        F: common_vendor.o(on_register)
      }) : {
        G: common_vendor.o(on_wx_register)
      });
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-0897572b"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../../.sourcemap/mp-weixin/pages/profile/register/register.js.map
