"use strict";
const common_vendor = require("../../../../common/vendor.js");
const userAgreementContent = `
		<div class="section">
			<div class="title">用户协议</div>
			<div class="subtitle">生效日期：2023年10月27日</div>
			<p class="paragraph">欢迎使用YourApp（以下简称“本应用”）。请您在使用前仔细阅读以下条款。通过访问或使用本应用，即表示您同意接受本协议所有条款的约束。如果您不同意本协议的任意内容，请您立即停止使用本应用。</p>
		</div>

		<div class="section">
			<div class="subtitle">一、 关于本协议</div>
			<ol class="ordered-list">
				<li class="list-item">本协议是您（下亦称“用户”）与YourApp运营方（下亦称“我们”）之间关于用户使用本应用服务所订立的协议。</li>
				<li class="list-item">本协议的内容包括协议正文、我们已经发布的或将来可能发布/更新的各类规则。所有规则为本协议不可分割的组成部分，与协议正文具有同等法律效力。</li>
				<li class="list-item">我们有权根据需要不时地制订、修改本协议及/或各类规则，并予以公布。变更后的协议和规则一经公布，立即自动生效，恕不再另行通知。您在本协议内容变更后继续使用本应用服务的，表示您同意接受修改后的协议和规则。</li>
			</ol>
		</div>

		<div class="section">
			<div class="subtitle">二、 服务内容</div>
			<ol class="ordered-list">
				<li class="list-item">本应用为用户提供[具体服务内容，例如：信息分享、社交互动、在线工具等]。</li>
				<li class="list-item">我们拥有对本应用服务内容进行修改、升级、更新的权利，恕不再另行通知。</li>
				<li class="list-item">本应用的部分功能可能需要您注册账号并登录后方可使用。</li>
			</ol>
		</div>

		<div class="section">
			<div class="subtitle">三、 用户账号</div>
			<ol class="ordered-list">
				<li class="list-item">您在注册账号时承诺遵守法律法规、社会主义制度、国家利益、公民合法权益、公共秩序、社会道德风尚和信息真实性等七条底线，不得在账号中包含违法、不良信息。</li>
				<li class="list-item">您应对您的账号和密码的安全负责，不得将其转让、出租或出借给他人使用。如发现他人未经授权使用您的账号，应立即通知我们。</li>
				<li class="list-item">您应遵守本应用的社区规范，不得利用账号或本应用服务从事任何违法或不正当活动。</li>
			</ol>
		</div>
		
		<div class="section">
			<div class="subtitle">四、 知识产权声明</div>
			<ol class="ordered-list">
				<li class="list-item">本应用内所有内容，包括但不限于文字、图片、音频、视频、图表、界面设计、版面框架、有关数据或电子文档等，均受《中华人民共和国著作权法》、《中华人民共和国商标法》、《中华人民共和国专利法》等相关法律法规及国际条约的保护，其知识产权归我们或相关权利人所有。</li>
				<li class="list-item">未经我们或相关权利人事先书面同意，您不得以任何方式使用、复制、传播、改编、发行、 publicly display, publicly perform, sublicense, or distribute the content of this application.</li>
			</ol>
		</div>
		
		<div class="section">
			<div class="subtitle">五、 免责声明</div>
			<ol class="ordered-list">
				<li class="list-item">您理解并同意，在法律允许的最大范围内，我们对本应用服务不作任何明示或暗示的保证，包括但不限于对适销性、特定用途的适用性和不侵权的保证。</li>
				<li class="list-item">在任何情况下，我们均不对因不可抗力、计算机病毒或黑客攻击、系统不稳定、您所在位置、因政府行为或其他第三方原因造成的服务中断或不能满足用户要求承担责任。</li>
				<li class="list-item">因您使用本应用服务而产生的任何直接、间接、偶然、特殊或后果性损害，我们不承担任何责任。</li>
			</ol>
		</div>
	`;
const privacyPolicyContent = `
		<div class="section">
			<div class="title">隐私政策</div>
			<div class="subtitle">生效日期：2023年10月27日</div>
			<p class="paragraph">YourApp（以下简称“我们”）尊重并保护用户的隐私。您在使用我们的服务时，我们可能会收集和使用您的相关信息。本隐私政策旨在向您说明我们如何收集、使用、存储、共享和保护您的个人信息，以及您享有的权利。请您在使用我们的服务前，仔细阅读并充分理解本隐私政策。</p>
		</div>

		<div class="section">
			<div class="subtitle">一、 我们收集的信息</div>
			<ol class="ordered-list">
				<li class="list-item"><span class="strong-text">您主动提供的信息：</span>当您注册账号、使用特定功能或参与活动时，您可能需要向我们提供某些信息，例如：
					<ul class="unordered-list">
						<li class="list-item">注册信息：手机号码、用户名、密码等。</li>
						<li class="list-item">个人资料：头像、昵称、性别、生日等。</li>
						<li class="list-item">发布内容：您在本应用内发布的文字、图片、视频等信息。</li>
					</ul>
				</li>
				<li class="list-item"><span class="strong-text">我们自动收集的信息：</span>为了提供更好的服务，我们可能会自动收集您在使用本应用时的相关信息，例如：
					<ul class="unordered-list">
						<li class="list-item">设备信息：设备型号、操作系统版本、唯一设备标识符（如IMEI、Android ID、IDFA等）、网络接入方式及类型、IP地址等。</li>
						<li class="list-item">日志信息：您使用本应用的详细情况，例如访问时间、浏览记录、点击数据、崩溃记录等。</li>
						<li class="list-item">位置信息：在获得您授权的前提下，我们可能会收集您的地理位置信息，以便提供基于位置的服务。</li>
					</ul>
				</li>
			</ol>
		</div>

		<div class="section">
			<div class="subtitle">二、 信息的使用</div>
			<p class="paragraph">我们收集的信息将用于以下目的：</p>
			<ul class="unordered-list">
				<li class="list-item">为您提供和改善我们的服务，包括个性化内容推荐、功能优化等。</li>
				<li class="list-item">保障服务的安全和稳定运行，例如检测和防范安全漏洞、欺诈行为。</li>
				<li class="list-item">与您进行沟通，例如发送服务通知、响应您的请求。</li>
				<li class="list-item">进行数据分析和研究，以了解用户行为，改进产品设计。</li>
				<li class="list-item">在法律要求或允许的情况下，用于其他合法目的。</li>
			</ul>
		</div>

		<div class="section">
			<div class="subtitle">三、 信息的存储与保护</div>
			<ol class="ordered-list">
				<li class="list-item"><span class="strong-text">存储地点：</span>您的个人信息将存储在中华人民共和国境内。</li>
				<li class="list-item"><span class="strong-text">存储期限：</span>我们仅在为提供服务所必需的期间内保留您的个人信息，但在下列情况下，我们可能会延长保留期限：
					<ul class="unordered-list">
						<li class="list-item">遵守法律、法规规定的保存期限。</li>
						<li class="list-item">为解决纠纷、保障合法权益等目的。</li>
					</ul>
				</li>
				<li class="list-item"><span class="strong-text">安全措施：</span>我们已采取符合业界标准的安全防护措施保护您的个人信息，防止数据被未经授权访问、使用、修改或泄露。</li>
			</ol>
		</div>
		
		<div class="section">
			<div class="subtitle">四、 信息的共享</div>
			<p class="paragraph">我们不会将您的个人信息出售给任何公司、组织或个人。但以下情况除外：</p>
			<ul class="unordered-list">
				<li class="list-item">事先获得您的明确授权或同意。</li>
				<li class="list-item">根据法律法规的规定或有权机关的强制性要求。</li>
				<li class="list-item">为履行本隐私政策或用户协议中的义务和行使我们的权利。</li>
				<li class="list-item">在涉及合并、收购、资产转让或破产清算时，如涉及到个人信息转让，我们将要求新的持有您个人信息的公司、组织继续受本隐私政策的约束，否则我们将要求该公司、组织重新向您征求授权同意。</li>
			</ul>
		</div>
	`;
const _sfc_main = {
  __name: "Agreement",
  setup(__props) {
    const policyType = common_vendor.ref("");
    const currentYear = (/* @__PURE__ */ new Date()).getFullYear();
    const pageTitle = common_vendor.computed(() => {
      return policyType.value === "privacy" ? "隐私政策" : "用户协议";
    });
    const policyContentHtml = common_vendor.computed(() => {
      return policyType.value === "privacy" ? privacyPolicyContent : userAgreementContent;
    });
    common_vendor.onLoad((options) => {
      policyType.value = options.type || "user";
    });
    return (_ctx, _cache) => {
      return {
        a: common_vendor.t(pageTitle.value),
        b: policyContentHtml.value,
        c: common_vendor.t(common_vendor.unref(currentYear))
      };
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-de27ff66"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../../../.sourcemap/mp-weixin/pages/profile/register/Agreement/Agreement.js.map
