"use strict";
const common_vendor = require("../../common/vendor.js");
const common_assets = require("../../common/assets.js");
const utils_request = require("../../utils/request.js");
const _sfc_main = {
  __name: "profile",
  setup(__props) {
    const user_info = common_vendor.ref({});
    common_vendor.onLoad((options) => {
      update_user_info();
    });
    common_vendor.onShow(async (options) => {
      showToastIfPresent(options);
      await update_user_info();
    });
    function showToastIfPresent(options) {
      if (options && options.showToastTitle) {
        common_vendor.index.showToast({
          title: options.showToastTitle,
          icon: options.showToastIcon || "none"
        });
      }
    }
    async function update_user_info() {
      const stored_info = common_vendor.index.getStorageSync("user_info");
      if (stored_info && stored_info.uid) {
        user_info.value = stored_info;
        return;
      }
      const token = common_vendor.index.getStorageSync("access_token");
      if (!token)
        return;
      try {
        const result = await utils_request.http_request("/get_my_userinfo", {}, true);
        if (result.code === 200) {
          user_info.value = result.data.userinfo || {};
          common_vendor.index.setStorageSync("user_info", user_info.value);
        }
      } catch (error) {
        common_vendor.index.__f__("error", "at pages/profile/profile.vue:109", "获取用户信息失败:", error);
      }
    }
    function navigate_to_user_info() {
      const user_info2 = common_vendor.index.getStorageSync("user_info");
      if (user_info2) {
        common_vendor.index.__f__("log", "at pages/profile/profile.vue:117", "[NAV] ✅ 跳转到用户信息页");
        common_vendor.index.navigateTo({
          url: "/pages/profile/view_userinfo/view_userinfo"
        });
      } else {
        common_vendor.index.__f__("log", "at pages/profile/profile.vue:122", "[NAV] 🔒 未登录，跳转到注册页");
        common_vendor.index.navigateTo({
          url: "/pages/profile/login/login"
        });
      }
    }
    function copy_uid() {
      const uid = user_info.value.uid;
      if (!uid) {
        common_vendor.index.showToast({
          title: "UID 不存在",
          icon: "none"
        });
        return;
      }
      common_vendor.index.setClipboardData({
        data: String(uid),
        success: () => {
          common_vendor.index.showToast({
            title: "复制成功",
            icon: "success"
          });
        },
        fail: () => {
          common_vendor.index.showToast({
            title: "复制失败",
            icon: "error"
          });
        }
      });
    }
    function navigate_to_settings() {
      common_vendor.index.getStorageSync("access_token");
      common_vendor.index.__f__("log", "at pages/profile/profile.vue:160", "[NAV] ✅ 跳转到设置页");
      common_vendor.index.navigateTo({
        url: "/pages/profile/user_setting/user_setting"
      });
    }
    function navigate_to_register() {
      common_vendor.index.__f__("log", "at pages/profile/profile.vue:168", "[NAV] ✅ 跳转到注册页");
      common_vendor.index.navigateTo({
        url: "/pages/profile/register/register"
      });
    }
    function navigate_to_login() {
      common_vendor.index.__f__("log", "at pages/profile/profile.vue:176", "[NAV] ✅ 跳转到登录页");
      common_vendor.index.navigateTo({
        url: "/pages/profile/login/login"
      });
    }
    return (_ctx, _cache) => {
      return {
        a: user_info.value.avatar_url ? user_info.value.avatar_url : "/static/image/profile.png",
        b: common_vendor.t(user_info.value.username ? user_info.value.username : "未注册/登录"),
        c: common_vendor.t(user_info.value.uid ? user_info.value.uid : "********"),
        d: common_assets._imports_0,
        e: common_vendor.o(copy_uid),
        f: common_vendor.o(navigate_to_user_info),
        g: common_assets._imports_0$1,
        h: common_vendor.o(navigate_to_settings),
        i: common_assets._imports_0$1,
        j: common_vendor.o(navigate_to_register),
        k: common_assets._imports_0$1,
        l: common_vendor.o(navigate_to_login)
      };
    };
  }
};
wx.createPage(_sfc_main);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/profile/profile.js.map
