"use strict";
const common_vendor = require("../../../common/vendor.js");
const utils_request = require("../../../utils/request.js");
const _sfc_main = {
  __name: "login",
  setup(__props) {
    const platform = common_vendor.ref("");
    const account = common_vendor.ref("");
    const password = common_vendor.ref("");
    const account_valid = common_vendor.ref(false);
    const password_valid = common_vendor.ref(false);
    const account_blurred = common_vendor.ref(false);
    const password_blurred = common_vendor.ref(false);
    const account_message = common_vendor.ref("");
    const password_message = common_vendor.ref("");
    common_vendor.onLoad((options) => {
      if (options.showToastTitle) {
        common_vendor.index.showToast({
          title: options.showToastTitle,
          icon: options.showToastIcon || "none"
        });
      }
      const system_info = common_vendor.index.getSystemInfoSync();
      platform.value = system_info.uniPlatform;
    });
    const validate_account = () => {
      var _a;
      account_blurred.value = true;
      const value = (_a = account.value) == null ? void 0 : _a.trim();
      if (!value) {
        account_message.value = "请输入账号";
        account_valid.value = false;
        return;
      }
      const phone_regex = /^1[0-9]{10}$/;
      const uid_regex = /^[0-9]{13}$/;
      const email_regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (phone_regex.test(value)) {
        account_message.value = "手机号格式正确";
        account_valid.value = true;
      } else if (uid_regex.test(value)) {
        account_message.value = "UID格式正确";
        account_valid.value = true;
      } else if (email_regex.test(value)) {
        account_message.value = "邮箱格式正确";
        account_valid.value = true;
      } else {
        account_message.value = "格式错误：支持邮箱、手机号或UID";
        account_valid.value = false;
      }
    };
    const validate_password = () => {
      var _a;
      password_blurred.value = true;
      const value = (_a = password.value) == null ? void 0 : _a.trim();
      if (!value) {
        password_message.value = "请输入密码";
        password_valid.value = false;
        return;
      }
      if (value.length < 6) {
        password_message.value = "密码不能少于6位";
        password_valid.value = false;
      } else {
        password_message.value = "密码格式正确";
        password_valid.value = true;
      }
    };
    const account_input_class = common_vendor.computed(() => ({
      valid: account_valid.value,
      invalid: !account_valid.value && account_blurred.value
    }));
    const account_message_class = common_vendor.computed(() => ({
      message: true,
      valid: account_valid.value,
      invalid: !account_valid.value && account_blurred.value
    }));
    const password_input_class = common_vendor.computed(() => ({
      valid: password_valid.value,
      invalid: !password_valid.value && password_blurred.value
    }));
    const password_message_class = common_vendor.computed(() => ({
      message: true,
      valid: password_valid.value,
      invalid: !password_valid.value && password_blurred.value
    }));
    const navigate_to_register = async () => {
      common_vendor.index.navigateTo({
        url: "/pages/profile/registry/registry"
      });
    };
    const handle_login = async (type) => {
      let login_data = {};
      if (type === "web") {
        if (!account_blurred.value) {
          common_vendor.index.showToast({
            title: "请填写账号",
            icon: "none"
          });
          return;
        }
        if (!password_blurred.value) {
          common_vendor.index.showToast({
            title: "请填写密码",
            icon: "none"
          });
          return;
        }
        if (!account_valid.value) {
          common_vendor.index.showToast({
            title: "请检查账号格式",
            icon: "none"
          });
          return;
        }
        if (!password_valid.value) {
          common_vendor.index.showToast({
            title: "密码不能少于6位",
            icon: "none"
          });
          return;
        }
        login_data = {
          account: String(account.value),
          password: String(password.value)
        };
      } else if (type === "wx") {
        try {
          const wx_res = await new Promise((resolve, reject) => {
            common_vendor.index.login({
              provider: "weixin",
              success: resolve,
              fail: reject
            });
          });
          login_data = {
            code: wx_res.code
          };
        } catch (err) {
          common_vendor.index.showToast({
            title: "微信登录失败",
            icon: "none"
          });
          return;
        }
      } else {
        common_vendor.index.showToast({
          title: "不支持的登录方式",
          icon: "none"
        });
        return;
      }
      try {
        const result = await utils_request.http_request("/login", login_data, false);
        if (result.code === 200) {
          const {
            access_token,
            refresh_token: new_refresh_token,
            expires_in
          } = result.data;
          common_vendor.index.setStorageSync("access_token", access_token);
          common_vendor.index.setStorageSync("refresh_token", new_refresh_token);
          common_vendor.index.setStorageSync("token_expire", Date.now() + expires_in * 1e3);
          try {
            const result_2 = await utils_request.http_request("/get_my_userinfo", {}, true);
            if (result_2.code === 200) {
              const userinfo = result_2.userinfo;
              common_vendor.index.setStorageSync("userinfo", userinfo);
              common_vendor.index.__f__("log", "at pages/profile/login/login.vue:246", "用户信息获取成功:", userinfo);
            } else {
              common_vendor.index.__f__("warn", "at pages/profile/login/login.vue:248", "获取用户信息失败:", result_2.msg || "未知错误");
            }
          } catch (infoError) {
            common_vendor.index.__f__("error", "at pages/profile/login/login.vue:252", "获取用户信息时发生网络或接口错误:", infoError);
          }
          common_vendor.index.showToast({
            title: "登录成功",
            icon: "success"
          });
          setTimeout(() => {
            common_vendor.index.switchTab({
              url: "/pages/jiashi/jiashi"
            });
          }, 500);
        } else if (result.code === 422) {
          common_vendor.index.__f__("log", "at pages/profile/login/login.vue:267", "账号未注册，跳转注册页");
        } else {
          common_vendor.index.showToast({
            title: result.msg || "登录失败",
            icon: "none"
          });
        }
      } catch (error) {
        common_vendor.index.__f__("error", "at pages/profile/login/login.vue:276", "登录请求出错：", error);
        common_vendor.index.showToast({
          title: "网络错误或服务器异常",
          icon: "none"
        });
      }
    };
    const on_web_login = () => handle_login("web");
    const on_wx_login = () => handle_login("wx");
    return (_ctx, _cache) => {
      return common_vendor.e({
        a: platform.value === "web"
      }, platform.value === "web" ? common_vendor.e({
        b: common_vendor.n(account_input_class.value),
        c: common_vendor.o(validate_account),
        d: account.value,
        e: common_vendor.o(($event) => account.value = $event.detail.value),
        f: account_message.value
      }, account_message.value ? {
        g: common_vendor.t(account_message.value),
        h: common_vendor.n(account_message_class.value)
      } : {}, {
        i: common_vendor.n(password_input_class.value),
        j: common_vendor.o(validate_password),
        k: password.value,
        l: common_vendor.o(($event) => password.value = $event.detail.value),
        m: password_message.value
      }, password_message.value ? {
        n: common_vendor.t(password_message.value),
        o: common_vendor.n(password_message_class.value)
      } : {}, {
        p: common_vendor.o(navigate_to_register),
        q: common_vendor.o(on_web_login)
      }) : {
        r: common_vendor.o(on_wx_login)
      });
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-41f81479"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../../.sourcemap/mp-weixin/pages/profile/login/login.js.map
