"use strict";
const common_vendor = require("../../../common/vendor.js");
const utils_request = require("../../../utils/request.js");
const _sfc_main = {
  __name: "editinput",
  setup(__props) {
    const edit_field = common_vendor.ref("");
    const title = common_vendor.ref("");
    const input_value = common_vendor.ref("");
    const xing = common_vendor.ref("");
    const ming = common_vendor.ref("");
    const saving = common_vendor.ref(false);
    common_vendor.onLoad((options) => {
      edit_field.value = options.field || "";
      title.value = options.title || "";
      input_value.value = options.inputValue || "";
      xing.value = options.xing || "";
      ming.value = options.ming || "";
      common_vendor.index.setNavigationBarTitle({
        title: title.value
      });
    });
    const on_save = async () => {
      if (saving.value)
        return;
      saving.value = true;
      try {
        const edit_dict = {};
        if (edit_field.value === "username") {
          const xing_val = xing.value.trim();
          const ming_val = ming.value.trim();
          const full_name = xing_val + ming_val;
          if (!xing_val && !ming_val) {
            common_vendor.index.showToast({
              icon: "none",
              title: "姓和名不能都为空"
            });
            return;
          }
          edit_dict.xing = xing_val;
          edit_dict.ming = ming_val;
          edit_dict.username = full_name;
        } else {
          const val = input_value.value.trim();
          if (!val) {
            common_vendor.index.showToast({
              icon: "none",
              title: `请输入${title.value}`
            });
            return;
          }
          edit_dict[edit_field.value] = val;
        }
        const response = await utils_request.http_request("/edit_userinfo", {
          edit_dict
        }, true);
        if (response.code === 200) {
          common_vendor.index.showToast({
            title: "保存成功"
          });
          const user_info = common_vendor.index.getStorageSync("user_info");
          const updated = { ...user_info, ...edit_dict };
          common_vendor.index.setStorageSync("user_info", updated);
          common_vendor.index.redirectTo({
            url: `/pages/profile/view_userinfo/view_userinfo`
          });
        }
      } catch (error) {
        common_vendor.index.showToast({
          icon: "none",
          title: error.message || "保存失败"
        });
        common_vendor.index.__f__("error", "at pages/profile/editinput/editinput.vue:116", "[ProfileEdit] 请求失败:", error);
      } finally {
        saving.value = false;
      }
    };
    return (_ctx, _cache) => {
      return common_vendor.e({
        a: edit_field.value === "username"
      }, edit_field.value === "username" ? {
        b: common_vendor.t(title.value),
        c: xing.value,
        d: common_vendor.o(($event) => xing.value = $event.detail.value),
        e: ming.value,
        f: common_vendor.o(($event) => ming.value = $event.detail.value),
        g: common_vendor.t(xing.value),
        h: common_vendor.t(ming.value)
      } : {
        i: common_vendor.t(title.value),
        j: input_value.value,
        k: common_vendor.o(($event) => input_value.value = $event.detail.value)
      }, {
        l: common_vendor.t(saving.value ? "保存中..." : "保存修改"),
        m: common_vendor.o(on_save),
        n: saving.value
      });
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-ee40df75"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../../.sourcemap/mp-weixin/pages/profile/editinput/editinput.js.map
