"use strict";
const common_vendor = require("../../common/vendor.js");
const _sfc_main = {
  __name: "message",
  setup(__props) {
    const choose_avatar = () => {
      common_vendor.index.chooseImage({
        count: 1,
        success: (res) => {
          const tempFilePaths = res.tempFilePaths;
          const access_token = common_vendor.index.getStorageSync("access_token");
          common_vendor.index.uploadFile({
            url: "https://wxxcx.iyouwc.cn:2026/upload_image",
            // 你的FastAPI上传接口地址
            filePath: tempFilePaths[0],
            // 临时文件路径
            name: "file",
            // 后端通过这个字段名获取文件，例如：fastapi中 `file: UploadFile = File(...)`
            formData: {
              "upload_path": "avatar"
            },
            header: {
              "Authorization": `Bearer ${access_token}`
            },
            success: (uploadRes) => {
              common_vendor.index.__f__("log", "at pages/message/message.vue:26", "上传成功", JSON.parse(uploadRes.data));
              common_vendor.index.showToast({
                title: "上传成功"
              });
            },
            fail: (err) => {
              common_vendor.index.__f__("error", "at pages/message/message.vue:32", "上传失败", err);
              common_vendor.index.showToast({
                title: "上传失败",
                icon: "none"
              });
            }
          });
        }
      });
    };
    return (_ctx, _cache) => {
      return {
        a: common_vendor.o(($event) => choose_avatar())
      };
    };
  }
};
wx.createPage(_sfc_main);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/message/message.js.map
