"use strict";
const common_vendor = require("../../common/vendor.js");
const utils_request = require("../../utils/request.js");
const canvas_max = 3;
const max_enlarge_scale = 5;
const max_reduction_scale = 0.4;
const card_width = 200;
const card_height = 80;
const padding = 100;
const _sfc_main = {
  __name: "jiashi",
  setup(__props) {
    const window_width = common_vendor.ref(0);
    const window_height = common_vendor.ref(0);
    const canvas_width = common_vendor.ref(0);
    const canvas_height = common_vendor.ref(0);
    const offset_x = common_vendor.ref(0);
    const offset_y = common_vendor.ref(0);
    const scale = common_vendor.ref(1);
    const last_touch = common_vendor.ref(null);
    const is_mouse_down = common_vendor.ref(false);
    const last_move_time = common_vendor.ref(0);
    common_vendor.ref(null);
    const Elements = common_vendor.ref([]);
    const ElementsLines = common_vendor.ref([]);
    common_vendor.ref([]);
    common_vendor.ref({});
    let expand_list_elements = common_vendor.ref([]);
    const get_windows_info = () => {
      try {
        const system_info = common_vendor.index.getSystemInfoSync();
        return {
          window_width: system_info.windowWidth,
          window_height: system_info.windowHeight
        };
      } catch (error) {
        common_vendor.index.__f__("error", "at pages/jiashi/jiashi.vue:124", "[INIT 家史] ❌ 获取系统信息失败:", error);
        if (typeof window !== "undefined" && window.innerWidth && window.innerHeight) {
          common_vendor.index.__f__("warn", "at pages/jiashi/jiashi.vue:126", "[INIT 家史] ❌ 使用浏览器宽高作为默认窗口大小。");
          return {
            window_width: window.innerWidth,
            window_height: window.innerHeight
          };
        }
        common_vendor.index.__f__("warn", "at pages/jiashi/jiashi.vue:132", "[INIT 家史] ❌ 使用默认窗口大小。");
        return {
          window_width: 375,
          window_height: 667
        };
      }
    };
    const load_all_relationship_tree_data = async () => {
      try {
        const response_relationship_tree_data = await utils_request.http_request("/generate_relationship_tree", {}, true);
        if (response_relationship_tree_data.code == "200") {
          const relationship_tree_data = response_relationship_tree_data.data;
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:149", "获取关系树数据成功", relationship_tree_data);
          common_vendor.index.setStorageSync("relationship_tree_data", relationship_tree_data);
          return relationship_tree_data;
        } else {
          const relationship_tree_data = {};
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:154", "获取关系树数据失败");
        }
      } catch (error) {
        common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:157", error);
      }
    };
    common_vendor.onLoad(async () => {
      const systemInfo = get_windows_info();
      window_width.value = systemInfo.window_width;
      window_height.value = systemInfo.window_height;
      canvas_width.value = window_width.value * canvas_max;
      canvas_height.value = window_height.value * canvas_max;
      offset_x.value = -(canvas_width.value / 2) + window_width.value / 2;
      offset_y.value = -(canvas_height.value / 2) + window_height.value / 2;
      const relationship_tree_data = await load_all_relationship_tree_data();
      await new Promise((resolve) => setTimeout(resolve, 500));
      const first_card = relationship_tree_data.data;
      Elements.value = [{
        x: canvas_width.value / 2 - card_width / 2,
        y: canvas_height.value / 2 - card_height / 2,
        username: first_card.username,
        uid: first_card.uid,
        gender_index: first_card.gender_index,
        year_of_birth: first_card.birthday ? first_card.birthday.split("-")[0] : "未知",
        avatar_url: first_card.avatar_url,
        parent_expand_state: false,
        // 父家庭关系展开状态
        child_expand_state: false,
        // 子家庭关系展开状态
        show_console_list: false,
        // 显示列表
        parent_uid: [],
        // 上级元素
        up_child_element: [],
        //上级子元素
        down_child_element: [],
        // 下级子元素
        child_family_index: 0,
        //显示第几个子家庭的信息
        parent_family_dict: relationship_tree_data.parent_family ? relationship_tree_data.parent_family : {},
        // 父家庭关系字典
        child_family_dict: relationship_tree_data.child_family ? relationship_tree_data.child_family : [{}]
        // 子家庭关系字典
      }];
    });
    const display_console_list = (element) => {
      if (element.show_console_list) {
        element.show_console_list = false;
      } else {
        for (let i = 0; i < expand_list_elements.value.length; i++) {
          expand_list_elements.value[i].show_console_list = false;
        }
        expand_list_elements.value = [];
        expand_list_elements.value.push(element);
        element.show_console_list = true;
      }
    };
    const expand_parent_family = (element) => {
      var _a, _b;
      common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:218", "展开父家庭");
      element.show_console_list = false;
      element.parent_expand_state = true;
      if (element.parent_family_dict && Object.keys(element.parent_family_dict).length > 0) {
        if (element.parent_family_dict.man) {
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:223", "存在父");
          const new_man_element = {
            x: element.x - card_width / 1.8,
            y: element.y - card_height * 1.5,
            username: element.parent_family_dict.man.data.username,
            uid: element.parent_family_dict.man.uid,
            gender_index: element.parent_family_dict.man.data.gender_index,
            year_of_birth: element.parent_family_dict.man.data.birthday ? element.parent_family_dict.man.data.birthday.split(
              "-"
            )[0] : "未知",
            avatar_url: element.parent_family_dict.man.data.avatar_url,
            parent_expand_state: false,
            // 父家庭关系展开状态
            child_expand_state: true,
            // 子家庭关系展开状态
            show_console_list: false,
            // 显示列表
            parent_uid: [element.uid],
            // 上级元素
            up_child_element: [],
            //上级子元素用于收缩
            down_child_element: [],
            // 下级子元素用于收缩
            child_family_index: 0,
            //显示第几个子家庭的信息
            parent_family_dict: element.parent_family_dict.man.parent_family || {},
            child_family_dict: element.parent_family_dict.man.child_family || [{}]
          };
          element.up_child_element.push(element.parent_family_dict.man.uid);
          Elements.value.push(new_man_element);
        }
        if (element.parent_family_dict.woman) {
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:248", "存在母");
          const new_woman_element = {
            x: element.x + card_width / 1.8,
            y: element.y - card_height * 1.5,
            username: element.parent_family_dict.woman.data.username,
            uid: element.parent_family_dict.woman.data.uid,
            gender_index: element.parent_family_dict.woman.data.gender_index,
            year_of_birth: element.parent_family_dict.woman.data.birthday ? element.parent_family_dict.woman.data.birthday.split("-")[0] : "未知",
            avatar_url: element.parent_family_dict.woman.data.avatar_url,
            parent_expand_state: false,
            // 父家庭关系展开状态
            child_expand_state: true,
            // 子家庭关系展开状态
            show_console_list: false,
            // 显示列表
            parent_uid: [element.uid],
            // 上级元素
            up_child_element: [],
            //上级子元素用于收缩
            down_child_element: [],
            // 下级子元素用于收缩
            child_family_index: 0,
            //显示第几个子家庭的信息
            parent_family_dict: element.parent_family_dict.woman.parent_family || {},
            child_family_dict: element.parent_family_dict.woman.child_family || [{}]
          };
          element.up_child_element.push(element.parent_family_dict.woman.uid);
          Elements.value.push(new_woman_element);
        }
        if (((_b = (_a = element.parent_family_dict) == null ? void 0 : _a.child) == null ? void 0 : _b.length) > 0) {
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:274", "存在兄弟");
          for (let i = 0; i < element.parent_family_dict.child.length; i++) {
            const new_sibling_element = {
              x: element.x + card_width * (i + 1),
              y: element.y,
              username: element.parent_family_dict.child[i].data.username,
              uid: element.parent_family_dict.child[i].uid,
              gender_index: element.parent_family_dict.child[i].data.gender_index,
              year_of_birth: element.parent_family_dict.child[i].data.birthday ? element.parent_family_dict.child[i].data.birthday.split("-")[0] : "未知",
              avatar_url: element.parent_family_dict.child[i].data.avatar_url,
              parent_expand_state: true,
              // 父家庭关系展开状态
              child_expand_state: false,
              // 子家庭关系展开状态
              show_console_list: false,
              // 显示列表
              parent_uid: [element.uid],
              // 上级元素
              up_child_element: [],
              //上级子元素用于收缩
              down_child_element: [],
              // 下级子元素用于收缩
              child_family_index: 0,
              //显示第几个子家庭的信息
              parent_family_dict: element.parent_family_dict.child[i].data.parent_family || {},
              child_family_dict: element.parent_family_dict.child[i].data.child_family || [{}]
            };
            element.up_child_element.push(element.parent_family_dict.child[i].uid);
            Elements.value.push(new_sibling_element);
          }
        }
      }
    };
    function collect_descendants(target_uid, uid_to_delete, upordown, level = 1) {
      if (uid_to_delete.has(target_uid))
        return;
      const current_element = Elements.value.find((item) => item.uid === target_uid);
      if (upordown == "up" && level == 1) {
        if (current_element && Array.isArray(current_element.up_child_element)) {
          for (const child_uid of current_element.up_child_element) {
            collect_descendants(child_uid, uid_to_delete, "none", 2);
            uid_to_delete.add(child_uid);
          }
        }
      } else if (upordown == "down" && level == 1) {
        if (current_element && Array.isArray(current_element.down_child_element)) {
          for (const child_uid of current_element.down_child_element) {
            collect_descendants(child_uid, uid_to_delete, "none", 2);
            uid_to_delete.add(child_uid);
          }
        }
      } else if (level != 1) {
        if (current_element && Array.isArray(current_element.up_child_element)) {
          for (const child_uid of current_element.up_child_element) {
            collect_descendants(child_uid, uid_to_delete, "none", 2);
            uid_to_delete.add(child_uid);
          }
        }
        if (current_element && Array.isArray(current_element.down_child_element)) {
          for (const child_uid of current_element.down_child_element) {
            collect_descendants(child_uid, uid_to_delete, "none", 2);
            uid_to_delete.add(child_uid);
          }
        }
      }
    }
    const close_parent_family = (element) => {
      common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:338", "关闭父家庭");
      element.show_console_list = false;
      element.parent_expand_state = false;
      const uid_to_delete = /* @__PURE__ */ new Set();
      collect_descendants(element.uid, uid_to_delete, "up", 1);
      Elements.value = Elements.value.filter((item) => !uid_to_delete.has(item.uid));
      element.child_element = [];
    };
    const close_child_family = (element) => {
      common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:348", "关闭子家庭");
      element.show_console_list = false;
      element.child_expand_state = false;
      const uid_to_delete = /* @__PURE__ */ new Set();
      collect_descendants(element.uid, uid_to_delete, "down", 1);
      Elements.value = Elements.value.filter((item) => !uid_to_delete.has(item.uid));
      element.child_element = [];
    };
    const expand_child_family = (element) => {
      common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:539", "展开子家庭");
      element.show_console_list = false;
      element.child_expand_state = true;
      if (element.child_family_dict && element.child_family_dict.length > 0) {
        const index = element.child_family_index;
        common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:544", `展示第 ${index} 个家庭`);
        if (element.child_family_dict[index].man) {
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:546", "存在丈夫");
          const new_husband_element = {
            x: element.x - card_width,
            y: element.y - 100,
            username: element.child_family_dict[index].man.data.username,
            uid: element.child_family_dict[index].man.uid,
            gender_index: element.child_family_dict[index].man.data.gender_index,
            year_of_birth: element.child_family_dict[index].man.data.birthday ? element.child_family_dict[index].man.data.birthday.split(
              "-"
            )[0] : "未知",
            avatar_url: element.child_family_dict[index].man.data.avatar_url,
            parent_expand_state: true,
            // 父家庭关系展开状态
            child_expand_state: false,
            // 子家庭关系展开状态
            show_console_list: false,
            // 显示列表
            parent_uid: [element.uid],
            // 上级元素
            up_child_element: [],
            //上级子元素用于收缩
            down_child_element: [],
            // 下级子元素用于收缩
            child_family_index: 0,
            //显示第几个子家庭的信息
            parent_family_dict: element.child_family_dict[index].man.parent_family || {},
            child_family_dict: element.child_family_dict[index].man.child_family || [{}]
          };
          element.down_child_element.push(element.child_family_dict[index].man.uid);
          Elements.value.push(new_husband_element);
        } else if (element.child_family_dict[index].woman) {
          common_vendor.index.__f__("log", "at pages/jiashi/jiashi.vue:571", "存在妻子");
          const new_wife_element = {
            x: element.x + card_width,
            y: element.y - 100,
            username: element.child_family_dict[index].woman.data.username,
            uid: element.child_family_dict[index].woman.uid,
            gender_index: element.child_family_dict[index].woman.data.gender_index,
            year_of_birth: element.child_family_dict[index].woman.data.birthday ? element.child_family_dict[index].woman.data.birthday.split(
              "-"
            )[0] : "未知",
            avatar_url: element.child_family_dict[index].woman.data.avatar_url,
            parent_expand_state: true,
            // 父家庭关系展开状态
            child_expand_state: false,
            // 子家庭关系展开状态
            show_console_list: false,
            // 显示列表
            parent_uid: [element.uid],
            // 上级元素
            up_child_element: [],
            //上级子元素用于收缩
            down_child_element: [],
            // 下级子元素用于收缩
            child_family_index: 0,
            //显示第几个子家庭的息
            parent_family_dict: element.child_family_dict[index].woman.parent_family || {},
            child_family_dict: element.child_family_dict[index].woman.child_family || [{}]
          };
          element.down_child_element.push(element.child_family_dict[index].woman.uid);
          Elements.value.push(new_wife_element);
        }
        if (Array.isArray(element.child_family_dict[index].child) && element.child_family_dict[index].child.length > 0) {
          for (let i = 0; i < element.child_family_dict[index].child.length; i++) {
            const new_child_element = {
              x: element.x + card_width * i,
              y: element.y + card_height + 20,
              username: element.child_family_dict[index].child[i].data.username,
              uid: element.child_family_dict[index].child[i].uid,
              gender_index: element.child_family_dict[index].child[i].data.gender_index,
              year_of_birth: element.child_family_dict[index].child[i].data.birthday ? element.child_family_dict[index].child[i].data.birthday.split("-")[0] : "未知",
              avatar_url: element.child_family_dict[index].child[i].data.avatar_url,
              parent_expand_state: true,
              // 父家庭关系展开状态
              child_expand_state: false,
              // 子家庭关系展开状态
              show_console_list: false,
              // 显示列表
              parent_uid: [element.uid],
              // 上级元素
              up_child_element: [],
              //上级子元素用于收缩
              down_child_element: [],
              // 下级子元素用于收缩
              child_family_index: 0,
              //显示第几个子家庭的息
              parent_family_dict: element.child_family_dict[index].child[i].data.parent_family || {},
              child_family_dict: element.child_family_dict[index].child[i].data.child_family || [{}]
            };
            element.down_child_element.push(element.child_family_dict[index].child[i].uid);
            Elements.value.push(new_child_element);
          }
        }
      }
    };
    const checkBoundaries = (newoffset_x, newoffset_y) => {
      const screenWidth = window_width.value;
      const screenHeight = window_height.value;
      const scaledWidth = canvas_width.value * scale.value;
      const scaledHeight = canvas_height.value * scale.value;
      let constrainedX = newoffset_x;
      if (scaledWidth <= screenWidth - 2 * padding) {
        constrainedX = (screenWidth - scaledWidth) / 2;
      } else {
        constrainedX = Math.min(
          Math.max(newoffset_x, screenWidth - scaledWidth - padding),
          padding
        );
      }
      let constrainedY = newoffset_y;
      if (scaledHeight <= screenHeight - 2 * padding) {
        constrainedY = (screenHeight - scaledHeight) / 2;
      } else {
        constrainedY = Math.min(
          Math.max(newoffset_y, screenHeight - scaledHeight - padding),
          padding
        );
      }
      return {
        offset_x: constrainedX,
        offset_y: constrainedY
      };
    };
    const handleTouchStart = (e) => {
      const touches = e.touches;
      if (touches.length === 1) {
        last_touch.value = {
          x: touches[0].pageX,
          y: touches[0].pageY,
          time: Date.now()
        };
      } else if (touches.length === 2) {
        const touch1 = touches[0];
        const touch2 = touches[1];
        const dx = touch2.pageX - touch1.pageX;
        const dy = touch2.pageY - touch1.pageY;
        last_touch.value = {
          distance: Math.sqrt(dx * dx + dy * dy),
          centerX: (touch1.pageX + touch2.pageX) / 2,
          centerY: (touch1.pageY + touch2.pageY) / 2
        };
      }
    };
    const handleTouchMove = (e) => {
      var _a, _b;
      if (Date.now() - last_move_time.value < 16) {
        return;
      }
      last_move_time.value = Date.now();
      const touches = e.touches;
      if (touches.length === 1 && ((_a = last_touch.value) == null ? void 0 : _a.x) !== void 0) {
        const deltaX = touches[0].pageX - last_touch.value.x;
        const deltaY = touches[0].pageY - last_touch.value.y;
        const constrained = checkBoundaries(
          offset_x.value + deltaX,
          offset_y.value + deltaY
        );
        offset_x.value = constrained.offset_x;
        offset_y.value = constrained.offset_y;
        last_touch.value = {
          x: touches[0].pageX,
          y: touches[0].pageY
        };
      } else if (touches.length === 2 && ((_b = last_touch.value) == null ? void 0 : _b.distance)) {
        const touch1 = touches[0];
        const touch2 = touches[1];
        const centerX = (touch1.pageX + touch2.pageX) / 2;
        const centerY = (touch1.pageY + touch2.pageY) / 2;
        const dx = touch2.pageX - touch1.pageX;
        const dy = touch2.pageY - touch1.pageY;
        const newDistance = Math.sqrt(dx * dx + dy * dy);
        const rawScale = scale.value * (newDistance / last_touch.value.distance);
        const clampedScale = Math.min(Math.max(rawScale, max_reduction_scale), max_enlarge_scale);
        const scaleRatio = clampedScale / scale.value;
        const offsetDeltaX = (centerX - offset_x.value) * (1 - scaleRatio);
        const offsetDeltaY = (centerY - offset_y.value) * (1 - scaleRatio);
        const constrained = checkBoundaries(
          offset_x.value + offsetDeltaX,
          offset_y.value + offsetDeltaY
        );
        scale.value = clampedScale;
        offset_x.value = constrained.offset_x;
        offset_y.value = constrained.offset_y;
        last_touch.value = {
          distance: newDistance,
          centerX,
          centerY
        };
      }
    };
    const handleTouchEnd = () => {
      last_touch.value = null;
    };
    const handleMouseDown = (e) => {
      is_mouse_down.value = true;
      const pageX = e.touches ? e.touches[0].pageX : e.pageX;
      const pageY = e.touches ? e.touches[0].pageY : e.pageY;
      last_touch.value = {
        x: pageX,
        y: pageY,
        time: Date.now()
      };
    };
    const handleMouseMove = (e) => {
      if (!is_mouse_down.value)
        return;
      if (Date.now() - last_move_time.value < 16)
        return;
      last_move_time.value = Date.now();
      const pageX = e.touches ? e.touches[0].pageX : e.pageX;
      const pageY = e.touches ? e.touches[0].pageY : e.pageY;
      const deltaX = pageX - last_touch.value.x;
      const deltaY = pageY - last_touch.value.y;
      const constrained = checkBoundaries(
        offset_x.value + deltaX,
        offset_y.value + deltaY
      );
      offset_x.value = constrained.offset_x;
      offset_y.value = constrained.offset_y;
      last_touch.value = {
        x: pageX,
        y: pageY
      };
    };
    const handleMouseUp = () => {
      is_mouse_down.value = false;
      last_touch.value = null;
    };
    const handleMagnifierTap = (type) => {
      const lastScale = scale.value;
      const step = 0.1;
      let changeScale;
      if (type === "big") {
        changeScale = parseFloat((lastScale + step).toFixed(2));
      } else {
        changeScale = parseFloat((lastScale - step).toFixed(2));
      }
      changeScale = Math.min(Math.max(changeScale, max_reduction_scale), max_enlarge_scale);
      const screenWidth = window_width.value;
      const screenHeight = window_height.value;
      const currentCenterX = (screenWidth / 2 - offset_x.value) / lastScale;
      const currentCenterY = (screenHeight / 2 - offset_y.value) / lastScale;
      const newoffset_x = screenWidth / 2 - currentCenterX * changeScale;
      const newoffset_y = screenHeight / 2 - currentCenterY * changeScale;
      const constrained = checkBoundaries(newoffset_x, newoffset_y);
      scale.value = changeScale;
      offset_x.value = constrained.offset_x;
      offset_y.value = constrained.offset_y;
    };
    const handlerestoreCenter = () => {
      scale.value = 1;
      offset_x.value = -(canvas_width.value / 2) + window_width.value / 2;
      offset_y.value = -(canvas_height.value / 2) + window_height.value / 2;
    };
    return (_ctx, _cache) => {
      return {
        a: common_vendor.o(($event) => handleMagnifierTap("big")),
        b: common_vendor.o(($event) => handlerestoreCenter()),
        c: common_vendor.o(($event) => handleMagnifierTap("small")),
        d: common_vendor.f(Elements.value, (element, index, i0) => {
          return {
            a: element.avatar_url,
            b: common_vendor.t(element.username),
            c: common_vendor.t(element.year_of_birth),
            d: common_vendor.t(element.expandState ? "展开" : "收缩"),
            e: element.show_console_list && !element.parent_expand_state,
            f: common_vendor.o(($event) => expand_parent_family(element), index),
            g: element.show_console_list && element.parent_expand_state,
            h: common_vendor.o(($event) => close_parent_family(element), index),
            i: element.show_console_list && !element.child_expand_state,
            j: common_vendor.o(($event) => expand_child_family(element), index),
            k: element.show_console_list && element.child_expand_state,
            l: common_vendor.o(($event) => close_child_family(element), index),
            m: element.show_console_list,
            n: common_vendor.o(() => {
            }, index),
            o: element.show_console_list,
            p: element.x + card_width + 2 + "px",
            q: element.y + card_height / 2 + "px",
            r: index,
            s: common_vendor.o(($event) => display_console_list(element), index),
            t: common_vendor.n(`elementGender-${element.gender_index}`),
            v: element.x + "px",
            w: element.y + "px"
          };
        }),
        e: common_vendor.f(ElementsLines.value, (line, index, i0) => {
          return {
            a: "line" + index,
            b: common_vendor.s(_ctx.getLineStyle(line))
          };
        }),
        f: `translate(${offset_x.value}px, ${offset_y.value}px) scale(${scale.value})`,
        g: canvas_width.value + "px",
        h: canvas_height.value + "px",
        i: common_vendor.o(handleTouchStart),
        j: common_vendor.o(handleTouchMove),
        k: common_vendor.o(handleTouchEnd),
        l: common_vendor.o(handleMouseDown),
        m: common_vendor.o(handleMouseMove),
        n: common_vendor.o(handleMouseUp),
        o: common_vendor.o(handleMouseUp)
      };
    };
  }
};
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-66870130"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/jiashi/jiashi.js.map
