"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const common_vendor = require("./common/vendor.js");
const utils_request = require("./utils/request.js");
if (!Math) {
  "./pages/jiashi/jiashi.js";
  "./pages/profile/profile.js";
  "./pages/message/message.js";
  "./pages/profile/view_userinfo/view_userinfo.js";
  "./pages/profile/editinput/editinput.js";
  "./pages/profile/user_setting/user_setting.js";
  "./pages/profile/register/Agreement/Agreement.js";
  "./pages/test/test.js";
  "./pages/profile/login/login.js";
  "./pages/profile/register/register.js";
}
const _sfc_main = {
  async onLaunch() {
    common_vendor.index.__f__("log", "at App.vue:8", "App Launch");
    const refresh_token = common_vendor.index.getStorageSync("refresh_token");
    const access_token = common_vendor.index.getStorageSync("access_token");
    const token_expire = common_vendor.index.getStorageSync("token_expire");
    if (!refresh_token) {
      common_vendor.index.__f__("log", "at App.vue:14", "没有 refresh_token，进入登录页");
      this.go_to_login();
      return;
    }
    if (access_token && token_expire && Date.now() < token_expire) {
      common_vendor.index.__f__("log", "at App.vue:25", "Token 有效，直接进入");
    } else {
      try {
        common_vendor.index.__f__("log", "at App.vue:28", "使用 refresh_token 刷新access_token");
        await utils_request.refresh_token_def();
        common_vendor.index.__f__("log", "at App.vue:30", "Token 刷新成功");
      } catch (error) {
        common_vendor.index.__f__("log", "at App.vue:32", "Token 刷新失败");
        common_vendor.index.clearStorageSync();
        this.go_to_login();
        return;
      }
    }
    const user_info = common_vendor.index.getStorageSync("user_info");
    if (!user_info) {
      try {
        const response = await utils_request.http_request("/get_my_userinfo", {}, true);
        if (response.code === 200 && response.userinfo) {
          common_vendor.index.setStorageSync("user_info", response.userinfo);
        } else {
          common_vendor.index.__f__("log", "at App.vue:50", "请求 user_info 失败:", response);
        }
      } catch (err) {
        common_vendor.index.__f__("log", "at App.vue:53", "获取用户信息失败", err);
      }
    }
  },
  onShow() {
    common_vendor.index.__f__("log", "at App.vue:59", "App Show");
  },
  onHide() {
    common_vendor.index.__f__("log", "at App.vue:63", "App Hide");
  },
  methods: {
    // 方法也改为 snake_case（Vue 支持）
    go_to_login() {
      common_vendor.index.reLaunch({
        url: "/pages/profile/login/login?showToastTitle=请先登录"
      });
    }
  }
};
function createApp() {
  const app = common_vendor.createSSRApp(_sfc_main);
  return {
    app
  };
}
createApp().app.mount("#app");
exports.createApp = createApp;
//# sourceMappingURL=../.sourcemap/mp-weixin/app.js.map
